local ingrediences_solvation=function(recipe)
	local ing = {}
	ing[#ing+1]={type = "fluid", name = "hydromnic-acid", amount = 120}
	for _, i in pairs(recipe.ingredients) do
		if i.name ~= "catalysator-brown" and i.name ~= "angels-void" then
			ing[#ing+1]=i
		end
	end
	return ing
end
local results_solvation=function(recipe)
	local ing = {}
	--ing[#ing+1]={type = "fluid", name = "hydromnic-acid", amount = 120}
	for _, i in pairs(recipe.results) do
		if i.name ~= "slag" then
			ing[#ing+1]={type = "item", name=i.name.."-omnide-salt", amount = i.amount}
		end
	end
	return ing
end
local salt_omnide_icon = function(metal)
	local nr = 5
    --Build the icons table
    local icons = {}
	icons[#icons+1] = {icon = "__omnimatter_crystal__/graphics/icons/omnide-salt.png"}
	icons[#icons+1] = {icon = data.raw.item[metal].icon,scale=0.4,shift={-10,10}}
    return icons
end

local find_type = function(recipe,name)
	for _,ing in pairs(recipe.ingredients) do
		if string.find(ing.name,name) then return true end
	end
	return false
end

local has_unlock = function(tech,recipe)
	for _,eff in pairs(data.raw.technology[tech].effects) do
		if eff.type == "unlock-recipe" and eff.recipe==recipe then return true end
	end
	return false
end

if angelsmods and angelsmods.refining then
	--log("test: "..settings.startup["omnicrystal-sloth"].value)
	--"angelsore7-crystallization-"

	
	local rec = {}
	local crystalines = {}
	for _,recipe in pairs(data.raw.recipe) do
		if recipe.enabled and string.find(recipe.name,"angelsore") and string.find(recipe.name,"processing") then
			local ing = ingrediences_solvation(recipe)
			local res = results_solvation(recipe)
			local metal = {}
			if #ing == 2 then metal = ing[2].name else metal = string.sub(res[1].name,1,string.len(res[1].name)-string.len("-omnide-salt")) end
			local ic = salt_omnide_icon(metal)			
			if not data.raw["item-subgroup"][recipe.subgroup.."-omnide"] then
				local cat = {
					type = "item-subgroup",
					name = recipe.subgroup.."-omnide",
					group = "omnicrystal",
					order = "aa",
				}
				crystalines[#crystalines+1]=cat
			end
			local loc_key = {"item-name."..metal}
			local solution = {
				type = "recipe",
				name = metal.."-salting",
				localised_name = {"recipe-name.omnide-salting", loc_key},
				localised_description = {"recipe-description.pure_extraction", loc_key},
				category = "omniplant",
				subgroup = recipe.subgroup.."-omnide",
				enabled = false,
				ingredients = ing,
				order = "a[angelsore1-crushed]",
				icons = ic,
				results = res,
				energy_required = 5,
			}
			crystalines[#crystalines+1]=solution
			
			--"angelsore-crushed-mix1-processing"
			if find_type(recipe,"crushed") then
				omni.lib.add_unlock_recipe("crystallology-1", metal.."-salting")
			elseif find_type(recipe,"chunk") then
				omni.lib.add_unlock_recipe("crystallology-2", metal.."-salting")	
			elseif find_type(recipe,"crystal") then
				omni.lib.add_unlock_recipe("crystallology-3", metal.."-salting")	
			elseif find_type(recipe,"pure") then
				omni.lib.add_unlock_recipe("crystallology-4", metal.."-salting"	)
			end
		end
	end
	data:extend(crystalines)
	local suffixes = {"-solvation","-crystalization","-omnitraction"}

	for _,suf in pairs(suffixes) do
		for i=1,4 do
			for _,eff in pairs(data.raw.technology["crystallology-"..i].effects) do
				if string.find(eff.recipe,"-salting") then
					if #data.raw.recipe[eff.recipe].ingredients > 2 then
						local metal = string.sub(eff.recipe,1,string.len(eff.recipe)-string.len("-salting"))
						omni.lib.add_unlock_recipe("crystallology-"..i, metal..suf)
					end
				end
			end
		end
	end
end
